# 3DQR — QR Menü + 3D Ürün Gösterimi (SaaS)

Multi-tenant **QR Menü** ve **3D ürün görüntüleme** platformu. Restoranlar menüyü QR ile paylaşır; misafirler uygulama indirmeden PWA üzerinden menüyü görüntüleyebilir ve ürünleri 3D model ile inceleyebilir.

## Yapı

- **apps/api** — NestJS backend (auth, tenant, ürün, upload, Stripe webhook)
- **apps/web** — Next.js restoran paneli (login, dashboard, ürün/kategori/şube/QR)
- **apps/menu** — Next.js PWA public menü (misafir, TR/EN, 3D viewer)
- **apps/mobile** — React Native (Expo) restoran uygulaması (ürün listesi, fiyat güncelle, 3D WebView)
- **packages/shared** — Ortak tipler, Zod şemaları, yardımcılar

## Gereksinimler

- Node.js 20+
- pnpm 9
- PostgreSQL 16
- (Opsiyonel) Redis, Docker

## Ortam Değişkenleri

### API (`apps/api`)

| Değişken | Açıklama | Örnek |
|----------|----------|--------|
| `DATABASE_URL` | PostgreSQL bağlantı URL’si | `postgresql://user:pass@localhost:5432/3dqr` |
| `JWT_SECRET` | JWT imza secret | Uzun, rastgele string |
| `JWT_EXPIRES_IN` | Access token süresi | `15m` |
| `CORS_ORIGIN` | İzin verilen origin’ler (virgülle ayrılmış) | `http://localhost:3000,http://localhost:3001` |
| `PORT` | API portu | `4000` |
| `MENU_PUBLIC_URL` | Public menü base URL (QR linkleri için) | `https://menu.domain.com` |
| `STRIPE_SECRET_KEY` | Stripe secret key | `sk_test_...` |
| `STRIPE_WEBHOOK_SECRET` | Webhook imza secret (Stripe CLI veya dashboard) | `whsec_...` |
| `AWS_ACCESS_KEY_ID` | S3 upload (opsiyonel) | |
| `AWS_SECRET_ACCESS_KEY` | S3 upload (opsiyonel) | |
| `AWS_S3_BUCKET` | S3 bucket adı (opsiyonel) | |
| `AWS_REGION` | S3 bölge | `eu-west-1` |
| `CDN_URL` | CDN base URL (public URL’ler için) | |

### Web Panel

| Değişken | Açıklama |
|----------|----------|
| `NEXT_PUBLIC_API_URL` | API base URL (örn. `http://localhost:4000`) |

### Menu PWA

| Değişken | Açıklama |
|----------|----------|
| `NEXT_PUBLIC_API_URL` | API base URL |

### Mobile

| Değişken | Açıklama |
|----------|----------|
| `EXPO_PUBLIC_API_URL` | API base URL (emulator için `http://10.0.2.2:4000` Android, `http://localhost:4000` iOS) |

## Kurulum (yerel)

```bash
# Bağımlılıklar
pnpm install

# Shared paketini derle
pnpm --filter @3dqr/shared build

# Veritabanı (PostgreSQL çalışıyor olmalı)
export DATABASE_URL="postgresql://postgres:postgres@localhost:5432/3dqr"
pnpm db:generate
pnpm db:migrate
pnpm db:seed

# API
pnpm dev:api          # http://localhost:4000

# Web panel (ayrı terminal)
pnpm dev:web          # http://localhost:3000

# Public menü (ayrı terminal)
pnpm dev:menu         # http://localhost:3001

# Mobil (ayrı terminal)
pnpm dev:mobile       # Expo dev server
```

Seed sonrası:

- **Panel giriş:** `owner@demo-restaurant.com` / `Admin123!`
- **Super admin:** `admin@3dqr.com` / `Admin123!`
- **Public menü:** http://localhost:3001/r/demo-restaurant

## Docker

```bash
# Sadece Postgres
docker-compose up -d postgres

# API + Web + Menu (Postgres ile)
docker-compose up -d postgres api web menu

# İlk kez: migration ve seed (API container’da veya yerelde)
# Yerelde: DATABASE_URL=postgresql://postgres:postgres@localhost:5432/3dqr pnpm db:migrate
# docker-compose exec api npx prisma migrate deploy
# docker-compose exec api npx prisma db seed
```

Not: API Dockerfile production için örnek; ilk çalıştırmada migration’ı siz çalıştırmalısınız.

## Stripe Webhook (lokal test)

1. [Stripe CLI](https://stripe.com/docs/stripe-cli) kurun.
2. Stripe’a login: `stripe login`
3. Webhook’u yönlendir:

```bash
stripe listen --forward-to localhost:4000/stripe/webhook
```

4. Çıktıdaki **webhook signing secret**’ı (`whsec_...`) kopyalayın.
5. API ortam değişkenine ekleyin: `STRIPE_WEBHOOK_SECRET=whsec_...`
6. API’yi bu env ile yeniden başlatın.

**Önemli:** Webhook endpoint’i **raw body** ile imza doğrular. NestJS tarafında `rawBody: true` ile oluşturulduğu için `req.rawBody` kullanılıyor; proxy kullanıyorsanız raw body’nin iletilmesini sağlayın.

Test event göndermek:

```bash
stripe trigger customer.subscription.updated
```

## API Özeti

- **Auth:** `POST /auth/register`, `POST /auth/login`, `POST /auth/refresh`, `POST /auth/logout`
- **Tenant:** `GET /tenant/me`, locations/tables CRUD, `GET /tenant/qr/tenant`, `GET /tenant/qr/location/:id`, `GET /tenant/qr/table/:id`
- **Public menü:** `GET /public/menu/:tenantSlug`, `.../location/:locationId`, `.../table/:tableId`
- **Ürünler:** `GET/POST /products`, `GET/PUT/DELETE /products/:id`, categories, `POST /products/bulk`
- **Upload:** `POST /upload/presigned` (body: productId, filename, contentType, type: image | model3d)
- **Stripe:** `POST /stripe/webhook`
- **Admin (super_admin):** `GET /admin/tenants`, `GET /admin/tenants/:id`, `DELETE /admin/tenants/:id`, `GET /admin/analytics`
- **Health:** `GET /health`

## URL Yapısı

- Panel: `https://app.domain.com`
- Public menü: `https://menu.domain.com/r/{tenantSlug}`
- Masa QR: `https://menu.domain.com/r/{tenantSlug}/l/{locationId}/t/{tableId}`

## Lisans

MIT.
