import { Injectable, CanActivate, ExecutionContext } from '@nestjs/common';
import { Reflector } from '@nestjs/core';
import type { UserRole } from '@prisma/client';

const ROLES_KEY = 'roles';

@Injectable()
export class RolesGuard implements CanActivate {
  constructor(private reflector: Reflector) {}

  canActivate(context: ExecutionContext): boolean {
    const required = this.reflector.getAllAndOverride<UserRole[]>(ROLES_KEY, [
      context.getHandler(),
      context.getClass(),
    ]);
    if (!required?.length) return true;
    const { user } = context.switchToHttp().getRequest();
    return required.includes(user?.role);
  }
}

export function Roles(...roles: UserRole[]) {
  return (target: object, key?: string | symbol) => {
    if (key) Reflect.defineMetadata(ROLES_KEY, roles, target.constructor.prototype, key);
    else Reflect.defineMetadata(ROLES_KEY, roles, target);
  };
}
