import { Module } from '@nestjs/common';
import { TenantController } from './tenant.controller';
import { TenantService } from './tenant.service';
import { PublicMenuController } from './public-menu.controller';
import { QrController } from './qr.controller';
import { QrService } from './qr.service';
import { PrismaModule } from '../prisma/prisma.module';
import { AuditModule } from '../audit/audit.module';

@Module({
  imports: [PrismaModule, AuditModule],
  controllers: [TenantController, PublicMenuController, QrController],
  providers: [TenantService, QrService],
  exports: [TenantService],
})
export class TenantModule {}
