import { z } from 'zod';

export const createCategorySchema = z.object({
  name: z.string().min(1),
  sortOrder: z.number().int().min(0).optional(),
});

export const updateCategorySchema = z.object({
  name: z.string().min(1).optional(),
  sortOrder: z.number().int().min(0).optional(),
});

export const createProductSchema = z.object({
  name: z.string().min(1),
  description: z.string().optional(),
  price: z.number().nonnegative(),
  currency: z.string().length(3).default('TRY'),
  allergens: z.array(z.string()).optional(),
  categoryId: z.string().uuid(),
  isActive: z.boolean().default(true),
  imageUrls: z.array(z.string().url()).optional(),
  model3dUrl: z.string().url().optional().nullable(),
});

export const updateProductSchema = z.object({
  name: z.string().min(1).optional(),
  description: z.string().optional().nullable(),
  price: z.number().nonnegative().optional(),
  currency: z.string().length(3).optional(),
  allergens: z.array(z.string()).optional().nullable(),
  categoryId: z.string().uuid().optional(),
  isActive: z.boolean().optional(),
  imageUrls: z.array(z.string().url()).optional(),
  model3dUrl: z.string().url().optional().nullable(),
});

export const bulkProductActionSchema = z.object({
  productIds: z.array(z.string().uuid()).min(1),
  action: z.enum(['move_category', 'set_active', 'set_inactive']),
  categoryId: z.string().uuid().optional(), // for move_category
});

export type CreateCategoryBody = z.infer<typeof createCategorySchema>;
export type UpdateCategoryBody = z.infer<typeof updateCategorySchema>;
export type CreateProductBody = z.infer<typeof createProductSchema>;
export type UpdateProductBody = z.infer<typeof updateProductSchema>;
export type BulkProductActionBody = z.infer<typeof bulkProductActionSchema>;
