/**
 * Shared types for 3DQR platform
 */

export type UserRole = 'owner' | 'admin' | 'editor';
export type SubscriptionStatus = 'active' | 'past_due' | 'canceled' | 'trialing';

export interface JwtPayload {
  sub: string;
  email: string;
  role: UserRole;
  tenantId?: string;
  iat?: number;
  exp?: number;
}

export interface PaginationQuery {
  page?: number;
  limit?: number;
  sortBy?: string;
  sortOrder?: 'asc' | 'desc';
}

export interface PaginatedResponse<T> {
  data: T[];
  total: number;
  page: number;
  limit: number;
  totalPages: number;
}

export interface AuditLogContext {
  userId: string;
  tenantId?: string;
  action: string;
  resource: string;
  resourceId?: string;
  metadata?: Record<string, unknown>;
}
