<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// --- VERİTABANI AYARLARI ---
$host = "localhost";
$db_name = "FORTUNA"; // cPanel'de oluşturduğunuz veritabanı adı
$username = "root";   // cPanel'de oluşturduğunuz kullanıcı adı
$password = "";       // cPanel'de belirlediğiniz şifre
// ---------------------------

try {
    $conn = new PDO("mysql:host=" . $host . ";dbname=" . $db_name . ";charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $exception) {
    http_response_code(500);
    echo json_encode(["error" => "Veritabanı bağlantı hatası: " . $exception->getMessage()]);
    exit();
}

// Tabloyu otomatik oluştur (Eğer yoksa)
$sql = "CREATE TABLE IF NOT EXISTS quotes (
    id INT AUTO_INCREMENT PRIMARY_KEY,
    name VARCHAR(255) NOT NULL,
    surname VARCHAR(255) NOT NULL,
    phone VARCHAR(255) NOT NULL,
    details TEXT,
    createdAt TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";

// Not: PDO MySQL'de "PRIMARY KEY" syntax hatası olabilir, basitçe id INT yapıp sonradan primary key eklenebilir ama 
// cPanel phpMyAdmin'den manuel oluşturmak daha garantidir. Ancak kodla deneyelim:
// Daha güvenli tablo oluşturma sorgusu:
$createTableSql = "CREATE TABLE IF NOT EXISTS quotes (
    id INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    surname VARCHAR(255) NOT NULL,
    phone VARCHAR(255) NOT NULL,
    details TEXT,
    createdAt TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;";

try {
    $conn->exec($createTableSql);
} catch(PDOException $e) {
    // Tablo zaten varsa veya hata olursa devam et
}

$method = $_SERVER['REQUEST_METHOD'];

// GET: Tüm kayıtları getir
if ($method === 'GET') {
    $stmt = $conn->prepare("SELECT * FROM quotes ORDER BY createdAt DESC");
    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($result);
}

// POST: Yeni kayıt ekle
elseif ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"));

    if(!empty($data->name) && !empty($data->surname) && !empty($data->phone)) {
        $query = "INSERT INTO quotes (name, surname, phone, details) VALUES (:name, :surname, :phone, :details)";
        $stmt = $conn->prepare($query);

        $detailsJson = json_encode($data->details); // JSON objesini stringe çevir

        $stmt->bindParam(":name", $data->name);
        $stmt->bindParam(":surname", $data->surname);
        $stmt->bindParam(":phone", $data->phone);
        $stmt->bindParam(":details", $detailsJson);

        if($stmt->execute()) {
            http_response_code(201);
            echo json_encode(["message" => "Talep başarıyla oluşturuldu."]);
        } else {
            http_response_code(503);
            echo json_encode(["message" => "Talep oluşturulamadı."]);
        }
    } else {
        http_response_code(400);
        echo json_encode(["message" => "Eksik veri."]);
    }
}

// DELETE: Kayıt sil (Örnek: api.php?id=5)
elseif ($method === 'DELETE') {
    $id = isset($_GET['id']) ? $_GET['id'] : die();

    $query = "DELETE FROM quotes WHERE id = :id";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(":id", $id);

    if($stmt->execute()) {
        http_response_code(200);
        echo json_encode(["message" => "Kayıt silindi."]);
    } else {
        http_response_code(503);
        echo json_encode(["message" => "Silinemedi."]);
    }
}
?>
